/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.position_tests;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.position_tests.IPositionRuleTest;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_5321;
import net.minecraft.class_6017;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import org.jetbrains.annotations.Nullable;

public class EntityTest
implements IPositionRuleTest {
    public static final String NAME = "entity_test";
    public static final Codec<EntityTest> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_6895.method_40340((class_5321)class_2378.field_25107).fieldOf("targets").forGetter(EntityTest::getTargets), (App)class_6017.method_35004((int)0, (int)100).fieldOf("count").forGetter(EntityTest::getIntProvider), (App)Codec.intRange((int)0, (int)64).fieldOf("radius").forGetter(EntityTest::getSize), (App)Codec.BOOL.optionalFieldOf("less_than").forGetter(EntityTest::isLessThan), (App)class_2350.field_29502.optionalFieldOf("look_direction").forGetter(EntityTest::getDirection), (App)Codec.INT.optionalFieldOf("offset").forGetter(EntityTest::getOffset)).apply((Applicative)i, EntityTest::new));
    static final IPositionRuleTest.Type<EntityTest> TYPE = new IPositionRuleTest.Type<EntityTest>(CODEC, "entity_test");
    private final class_6885<class_1299<?>> targets;
    private final class_6017 intProvider;
    private final boolean lessThan;
    private final int size;
    private final int offset;
    @Nullable
    private final class_2350 direction;

    private EntityTest(class_6885<class_1299<?>> targets, class_6017 intProvider, int size, Optional<Boolean> lessThan, Optional<class_2350> direction, Optional<Integer> offset) {
        this.targets = targets;
        this.intProvider = intProvider;
        this.size = size;
        this.lessThan = lessThan.orElse(false);
        this.direction = direction.orElse(null);
        this.offset = offset.orElse(0);
    }

    public class_6017 getIntProvider() {
        return this.intProvider;
    }

    public class_6885<class_1299<?>> getTargets() {
        return this.targets;
    }

    public int getSize() {
        return this.size;
    }

    public Optional<Boolean> isLessThan() {
        return Optional.of(this.lessThan);
    }

    public Optional<Integer> getOffset() {
        return Optional.of(this.offset);
    }

    public Optional<class_2350> getDirection() {
        return Optional.ofNullable(this.direction);
    }

    @Override
    public boolean test(Supplier<class_6880<class_1959>> biome, class_2338 pos, class_1937 level) {
        class_238 aabb = new class_238(pos).method_1014((double)this.size);
        if (this.direction != null && this.offset != 0) {
            aabb = aabb.method_989((double)(this.direction.method_10148() * this.offset), (double)(this.direction.method_10164() * this.offset), (double)(this.direction.method_10165() * this.offset));
        }
        List list = level.method_8333((class_1297)null, aabb, this::isEntityValid);
        int sampled = this.intProvider.method_35008(level.field_9229);
        if (this.lessThan) {
            return list.size() <= sampled;
        }
        return list.size() >= sampled;
    }

    public boolean isEntityValid(class_1297 e) {
        return this.targets.method_40241((class_6880)e.method_5864().method_40124());
    }

    @Override
    public IPositionRuleTest.Type<?> getType() {
        return TYPE;
    }
}

